/*
 * Decompiled with CFR 0.152.
 */
package reliquary.util.potions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import reliquary.init.ModItems;
import reliquary.reference.Settings;
import reliquary.util.LogHelper;
import reliquary.util.StackHelper;
import reliquary.util.potions.PotionEssence;
import reliquary.util.potions.PotionEssenceComparator;
import reliquary.util.potions.PotionIngredient;
import reliquary.util.potions.XRPotionHelper;

public class PotionMap {
    protected static final List<PotionIngredient> ingredients = new ArrayList<PotionIngredient>();
    public static final List<PotionEssence> potionCombinations = new ArrayList<PotionEssence>();
    public static final List<PotionEssence> uniquePotionEssences = new ArrayList<PotionEssence>();
    public static final List<PotionEssence> uniquePotions = new ArrayList<PotionEssence>();

    private PotionMap() {
    }

    public static void initPotionMap() {
        PotionMap.setDefaultInConfigIfEmpty();
        PotionMap.loadPotionMapFromSettings();
        LogHelper.debug("Starting calculation of potion combinations");
        PotionMap.loadPotionCombinations();
        PotionMap.loadUniquePotions();
        LogHelper.debug("Done with potion combinations");
    }

    private static void setDefaultInConfigIfEmpty() {
        if (((List)Settings.COMMON.potions.potionMap.get()).isEmpty()) {
            Settings.COMMON.potions.potionMap.set(PotionMap.getDefaultConfigPotionMap());
        }
    }

    private static void loadUniquePotions() {
        uniquePotionEssences.clear();
        uniquePotions.clear();
        for (PotionEssence essence : potionCombinations) {
            boolean found = false;
            for (PotionEssence uniqueEssence : uniquePotionEssences) {
                if (!PotionMap.effectsEqual(essence.getEffects(), uniqueEssence.getEffects())) continue;
                found = true;
                break;
            }
            if (found) continue;
            uniquePotionEssences.add(essence);
            PotionMap.addUniquePotions(essence);
        }
        uniquePotionEssences.sort(new PotionEssenceComparator());
        uniquePotions.sort(new PotionEssenceComparator());
    }

    private static void addUniquePotions(PotionEssence essence) {
        uniquePotions.add(essence);
        if (Boolean.TRUE.equals(Settings.COMMON.potions.redstoneAndGlowstone.get())) {
            PotionEssence redstone = essence.copy();
            redstone.setEffects(XRPotionHelper.augmentPotionEffects(redstone.getEffects(), 1, 0));
            redstone.setRedstoneCount(1);
            uniquePotions.add(redstone);
            PotionEssence glowstone = essence.copy();
            glowstone.setEffects(XRPotionHelper.augmentPotionEffects(redstone.getEffects(), 0, 1));
            glowstone.setGlowstoneCount(1);
            uniquePotions.add(glowstone);
            PotionEssence redstoneGlowstone = essence.copy();
            redstoneGlowstone.setEffects(XRPotionHelper.augmentPotionEffects(redstone.getEffects(), 1, 1));
            redstoneGlowstone.setRedstoneCount(1);
            redstoneGlowstone.setGlowstoneCount(1);
            uniquePotions.add(redstoneGlowstone);
        }
    }

    private static void loadPotionCombinations() {
        potionCombinations.clear();
        for (PotionIngredient ingredient1 : ingredients) {
            for (PotionIngredient ingredient2 : ingredients) {
                PotionEssence twoEssence;
                if (ingredient1.getItem().m_41720_() == ingredient2.getItem().m_41720_() || (twoEssence = new PotionEssence.Builder().setIngredients(ingredient1, ingredient2).setEffects(XRPotionHelper.combineIngredients(ingredient1, ingredient2)).build()).getEffects().size() <= 0 || twoEssence.getEffects().size() > (Integer)Settings.COMMON.potions.maxEffectCount.get()) continue;
                PotionMap.addPotionCombination(twoEssence);
                if (!Boolean.TRUE.equals(Settings.COMMON.potions.threeIngredients.get())) continue;
                for (PotionIngredient ingredient3 : ingredients) {
                    if (ingredient3.getItem().m_41720_() == ingredient1.getItem().m_41720_() || ingredient3.getItem().m_41720_() == ingredient2.getItem().m_41720_()) continue;
                    PotionEssence threeEssence = new PotionEssence.Builder().setIngredients(ingredient1, ingredient2, ingredient3).setEffects(XRPotionHelper.combineIngredients(ingredient1, ingredient2, ingredient3)).build();
                    if (PotionMap.effectsEqual(twoEssence.getEffects(), threeEssence.getEffects())) continue;
                    PotionMap.addPotionCombination(threeEssence);
                }
            }
        }
    }

    private static void addPotionCombination(PotionEssence newEssence) {
        for (PotionEssence essence : potionCombinations) {
            if (PotionMap.ingredientsEqual(essence.getIngredients(), newEssence.getIngredients())) {
                return;
            }
            if (!PotionMap.effectsEqual(essence.getEffects(), newEssence.getEffects(), (Boolean)Settings.COMMON.potions.differentDurations.get()) || PotionMap.effectsEqual(essence.getEffects(), newEssence.getEffects())) continue;
            return;
        }
        potionCombinations.add(newEssence);
    }

    private static boolean ingredientsEqual(List<PotionIngredient> a, List<PotionIngredient> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (PotionIngredient ingredientA : a) {
            boolean found = false;
            for (PotionIngredient ingredientB : b) {
                if (ingredientA.getItem().m_41720_() != ingredientB.getItem().m_41720_()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static boolean effectsEqual(List<MobEffectInstance> a, List<MobEffectInstance> b) {
        return PotionMap.effectsEqual(a, b, true);
    }

    private static boolean effectsEqual(List<MobEffectInstance> a, List<MobEffectInstance> b, boolean compareDuration) {
        if (a.size() != b.size()) {
            return false;
        }
        for (MobEffectInstance effectA : a) {
            boolean found = false;
            for (MobEffectInstance effectB : b) {
                if (!effectA.m_19576_().equals(effectB.m_19576_()) || compareDuration && effectA.m_19557_() != effectB.m_19557_() || effectA.m_19564_() != effectB.m_19564_()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static void loadPotionMapFromSettings() {
        ingredients.clear();
        Pattern validEntry = Pattern.compile("[a-z_:0-9]+=[a-z_0-9:\\.\\|;]+");
        for (String entry : (List)Settings.COMMON.potions.potionMap.get()) {
            if (validEntry.matcher(entry).matches()) {
                String[] entryParts = entry.split("=");
                String name = entryParts[0];
                String[] effects = entryParts[1].split(";");
                PotionMap.addItemEffectsToPotionMap(name, effects);
                continue;
            }
            LogHelper.error("Potion map entry \"" + entry + "\" is not valid.\nNeeds to be mod:item_or_block_registry_name=potion_effect_name|duration_multiplier|amplifier\nPotion effect part (\"potion_effect_name|...|amplifier\") can be optionally repeated if there are multiple effects on item, the individual potion sections are delimited by semicolon \";\"\nDuration multiplier is multiples of 15 seconds the potion will last");
        }
    }

    private static void addItemEffectsToPotionMap(String name, String[] effects) {
        StackHelper.getItemStackFromName(name).ifPresent(stack -> {
            PotionIngredient ingredient = new PotionIngredient((ItemStack)stack);
            for (String effect : effects) {
                String[] effectValues = effect.split("\\|");
                String potionName = effectValues[0];
                if (potionName.isEmpty()) continue;
                short durationWeight = Short.parseShort(effectValues[1]);
                short ampWeight = Short.parseShort(effectValues[2]);
                ingredient.addEffect(potionName, durationWeight, ampWeight);
            }
            if (!ingredient.getEffects().isEmpty()) {
                ingredients.add(ingredient);
            }
        });
    }

    public static List<String> getDefaultConfigPotionMap() {
        ArrayList<String> potionMap = new ArrayList<String>();
        PotionMap.addPotionIngredient(potionMap, Items.f_42501_, PotionMap.speed(3, 0), PotionMap.haste(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42410_, PotionMap.heal(0), PotionMap.hboost(3, 0), PotionMap.cure(0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42413_, PotionMap.blind(1), PotionMap.absorb(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42413_, PotionMap.invis(1), PotionMap.wither(0, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42402_, PotionMap.jump(3, 0), PotionMap.weak(1, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42404_, PotionMap.harm(0), PotionMap.hboost(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42405_, PotionMap.heal(0), PotionMap.hboost(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42484_, PotionMap.harm(0), PotionMap.dboost(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42485_, PotionMap.slow(1, 0), PotionMap.fatigue(1, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42454_, PotionMap.resist(3, 0), PotionMap.absorb(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42461_, PotionMap.slow(1, 0), PotionMap.hboost(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42521_, PotionMap.absorb(3, 0), PotionMap.regen(0, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42497_, PotionMap.heal(0), PotionMap.hboost(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42539_, PotionMap.jump(3, 0), PotionMap.weak(1, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42496_, PotionMap.resist(3, 0), PotionMap.absorb(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42499_, PotionMap.weak(1, 0), PotionMap.fatigue(1, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42577_, PotionMap.invis(1), PotionMap.fireres(1));
        PotionMap.addPotionIngredient(potionMap, Items.f_42579_, PotionMap.slow(1, 0), PotionMap.satur(0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42581_, PotionMap.nausea(1), PotionMap.poison(1));
        PotionMap.addPotionIngredient(potionMap, Items.f_42583_, PotionMap.nausea(1), PotionMap.hunger(1), PotionMap.wither(0, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42587_, PotionMap.dboost(0, 0), PotionMap.haste(0, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42619_, PotionMap.vision(3), PotionMap.hboost(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42620_, PotionMap.hboost(3, 0), PotionMap.satur(0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42526_, PotionMap.satur(0), PotionMap.breath(1));
        PotionMap.addPotionIngredient(potionMap, Items.f_42591_, PotionMap.vision(4), PotionMap.poison(2));
        PotionMap.addPotionIngredient(potionMap, Items.f_42593_, PotionMap.dboost(4, 0), PotionMap.harm(0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42416_, PotionMap.resist(4, 0), PotionMap.slow(2, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42401_, PotionMap.slow(2, 0), PotionMap.fatigue(2, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42406_, PotionMap.hboost(4, 0), PotionMap.satur(0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42486_, PotionMap.fatigue(2, 0), PotionMap.satur(0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42518_, PotionMap.resist(4, 0), PotionMap.fireres(2));
        PotionMap.addPotionIngredient(potionMap, Items.f_42530_, PotionMap.satur(0), PotionMap.breath(2));
        PotionMap.addPotionIngredient(potionMap, Items.f_42534_, PotionMap.haste(4, 0), PotionMap.dboost(4, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42532_, PotionMap.blind(2), PotionMap.invis(2));
        PotionMap.addPotionIngredient(potionMap, Items.f_42500_, PotionMap.weak(2, 0), PotionMap.fatigue(2, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42572_, PotionMap.heal(0), PotionMap.satur(0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42028_, PotionMap.heal(0), PotionMap.speed(4, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42580_, PotionMap.resist(4, 0), PotionMap.satur(0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42582_, PotionMap.jump(4, 0), PotionMap.satur(0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42674_, PotionMap.satur(0), PotionMap.regen(1, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42675_, PotionMap.poison(2), PotionMap.wither(1, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42692_, PotionMap.harm(0), PotionMap.dboost(4, 0));
        PotionMap.addPotionIngredient(potionMap, (Item)ModItems.ZOMBIE_HEART.get(), PotionMap.nausea(2), PotionMap.hunger(2), PotionMap.wither(1, 0));
        PotionMap.addPotionIngredient(potionMap, (Item)ModItems.SQUID_BEAK.get(), PotionMap.hunger(2), PotionMap.breath(2));
        PotionMap.addPotionIngredient(potionMap, Items.f_42687_, PotionMap.invis(1), PotionMap.fireres(1), PotionMap.speed(3, 0), PotionMap.haste(3, 0), PotionMap.absorb(3, 0), PotionMap.regen(0, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42542_, PotionMap.dboost(4, 0), PotionMap.harm(0), PotionMap.resist(4, 0), PotionMap.fireres(2));
        PotionMap.addPotionIngredient(potionMap, Items.f_42546_, PotionMap.dboost(3, 0), PotionMap.haste(3, 0), PotionMap.heal(0), PotionMap.speed(4, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42586_, PotionMap.regen(3, 0), PotionMap.absorb(5, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42592_, PotionMap.vision(4), PotionMap.poison(2), PotionMap.speed(3, 0), PotionMap.haste(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42677_, PotionMap.dboost(3, 0), PotionMap.haste(3, 0), PotionMap.hboost(3, 0), PotionMap.vision(3));
        PotionMap.addPotionIngredient(potionMap, Items.f_42417_, PotionMap.dboost(4, 0), PotionMap.haste(4, 0), PotionMap.cure(0));
        PotionMap.addPotionIngredient(potionMap, (Item)ModItems.RIB_BONE.get(), PotionMap.weak(3, 0), PotionMap.fatigue(3, 0), PotionMap.cure(0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42584_, PotionMap.invis(5), PotionMap.speed(5, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42585_, PotionMap.dboost(8, 0), PotionMap.harm(0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42613_, PotionMap.dboost(4, 0), PotionMap.harm(0), PotionMap.blind(1), PotionMap.absorb(3, 0));
        PotionMap.addPotionIngredient(potionMap, (Item)ModItems.CATALYZING_GLAND.get(), PotionMap.regen(3, 0), PotionMap.hboost(5, 0));
        PotionMap.addPotionIngredient(potionMap, (Item)ModItems.CHELICERAE.get(), PotionMap.poison(3), PotionMap.weak(3, 0));
        PotionMap.addPotionIngredient(potionMap, (Item)ModItems.SLIME_PEARL.get(), PotionMap.resist(5, 0), PotionMap.absorb(5, 0));
        PotionMap.addPotionIngredient(potionMap, (Item)ModItems.KRAKEN_SHELL_FRAGMENT.get(), PotionMap.absorb(5, 0), PotionMap.breath(5));
        PotionMap.addPotionIngredient(potionMap, (Item)ModItems.BAT_WING.get(), PotionMap.jump(5, 0), PotionMap.weak(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42436_, PotionMap.cure(1));
        PotionMap.addPotionIngredient(potionMap, Items.f_42436_, PotionMap.cure(2));
        PotionMap.addPotionIngredient(potionMap, Items.f_42415_, PotionMap.resist(6, 1), PotionMap.absorb(6, 1), PotionMap.fireres(6), PotionMap.cure(0));
        PotionMap.addPotionIngredient(potionMap, (Item)ModItems.WITHERED_RIB.get(), PotionMap.wither(2, 1), PotionMap.weak(3, 1), PotionMap.slow(3, 1), PotionMap.fatigue(3, 1), PotionMap.cure(0));
        PotionMap.addPotionIngredient(potionMap, Items.f_42545_, PotionMap.dboost(6, 1), PotionMap.invis(6), PotionMap.speed(6, 1), PotionMap.harm(1));
        PotionMap.addPotionIngredient(potionMap, Items.f_42616_, PotionMap.haste(6, 1), PotionMap.speed(6, 1), PotionMap.hboost(6, 1), PotionMap.cure(1));
        PotionMap.addPotionIngredient(potionMap, Items.f_42686_, PotionMap.hboost(24, 1), PotionMap.regen(24, 1), PotionMap.absorb(24, 1), PotionMap.cure(2));
        PotionMap.addPotionIngredient(potionMap, (Item)ModItems.MOLTEN_CORE.get(), PotionMap.dboost(6, 1), PotionMap.fireres(6), PotionMap.harm(1));
        PotionMap.addPotionIngredient(potionMap, (Item)ModItems.EYE_OF_THE_STORM.get(), PotionMap.haste(24, 1), PotionMap.speed(24, 1), PotionMap.jump(24, 1), PotionMap.harm(1), PotionMap.cure(1));
        PotionMap.addPotionIngredient(potionMap, (Item)ModItems.FERTILE_ESSENCE.get(), PotionMap.hboost(8, 1), PotionMap.regen(3, 1), PotionMap.heal(1), PotionMap.satur(1), PotionMap.weak(9, 1), PotionMap.fatigue(9, 1), PotionMap.cure(0));
        PotionMap.addPotionIngredient(potionMap, (Item)ModItems.FROZEN_CORE.get(), PotionMap.absorb(6, 1), PotionMap.slow(3, 1), PotionMap.fatigue(3, 1), PotionMap.harm(1), PotionMap.fireres(6));
        PotionMap.addPotionIngredient(potionMap, (Item)ModItems.NEBULOUS_HEART.get(), PotionMap.vision(6), PotionMap.invis(6), PotionMap.harm(1), PotionMap.hboost(6, 1), PotionMap.dboost(6, 1), PotionMap.speed(6, 1), PotionMap.haste(6, 1));
        PotionMap.addPotionIngredient(potionMap, (Item)ModItems.INFERNAL_CLAW.get(), PotionMap.harm(1), PotionMap.resist(6, 1), PotionMap.fireres(6), PotionMap.dboost(6, 1), PotionMap.satur(1), PotionMap.heal(1));
        return potionMap;
    }

    private static String harm(int potency) {
        return PotionMap.effectString("instant_damage", Integer.toString(0), Integer.toString(potency));
    }

    private static String heal(int potency) {
        return PotionMap.effectString("instant_health", Integer.toString(0), Integer.toString(potency));
    }

    private static String satur(int potency) {
        return PotionMap.effectString("saturation", Integer.toString(0), Integer.toString(potency));
    }

    private static String invis(int duration) {
        return PotionMap.effectString("invisibility", Integer.toString(duration), Integer.toString(0));
    }

    private static String absorb(int duration, int potency) {
        return PotionMap.effectString("absorption", Integer.toString(duration), Integer.toString(potency));
    }

    private static String hboost(int duration, int potency) {
        return PotionMap.effectString("health_boost", Integer.toString(duration), Integer.toString(potency));
    }

    private static String dboost(int duration, int potency) {
        return PotionMap.effectString("strength", Integer.toString(duration), Integer.toString(potency));
    }

    private static String speed(int duration, int potency) {
        return PotionMap.effectString("speed", Integer.toString(duration), Integer.toString(potency));
    }

    private static String haste(int duration, int potency) {
        return PotionMap.effectString("haste", Integer.toString(duration), Integer.toString(potency));
    }

    private static String slow(int duration, int potency) {
        return PotionMap.effectString("slowness", Integer.toString(duration), Integer.toString(potency));
    }

    private static String fatigue(int duration, int potency) {
        return PotionMap.effectString("mining_fatigue", Integer.toString(duration), Integer.toString(potency));
    }

    private static String breath(int duration) {
        return PotionMap.effectString("water_breathing", Integer.toString(duration), Integer.toString(0));
    }

    private static String vision(int duration) {
        return PotionMap.effectString("night_vision", Integer.toString(duration), Integer.toString(0));
    }

    private static String resist(int duration, int potency) {
        return PotionMap.effectString("resistance", Integer.toString(duration), Integer.toString(potency));
    }

    private static String fireres(int duration) {
        return PotionMap.effectString("fire_resistance", Integer.toString(duration), Integer.toString(0));
    }

    private static String weak(int duration, int potency) {
        return PotionMap.effectString("weakness", Integer.toString(duration), Integer.toString(potency));
    }

    private static String jump(int duration, int potency) {
        return PotionMap.effectString("jump_boost", Integer.toString(duration), Integer.toString(potency));
    }

    private static String nausea(int duration) {
        return PotionMap.effectString("nausea", Integer.toString(duration), Integer.toString(0));
    }

    private static String hunger(int duration) {
        return PotionMap.effectString("hunger", Integer.toString(duration), Integer.toString(0));
    }

    private static String regen(int duration, int potency) {
        return PotionMap.effectString("regeneration", Integer.toString(duration), Integer.toString(potency));
    }

    private static String poison(int duration) {
        return PotionMap.effectString("poison", Integer.toString(duration), Integer.toString(0));
    }

    private static String wither(int duration, int potency) {
        return PotionMap.effectString("wither", Integer.toString(duration), Integer.toString(potency));
    }

    private static String blind(int duration) {
        return PotionMap.effectString("blindness", Integer.toString(duration), Integer.toString(0));
    }

    private static String cure(int potency) {
        return PotionMap.effectString("reliquary:cure", Integer.toString(1), Integer.toString(potency));
    }

    private static String effectString(String name, String duration, String potency) {
        return name + "|" + duration + "|" + potency;
    }

    private static void addPotionIngredient(List<String> potionMap, Item ingredient, String ... effects) {
        PotionMap.addPotionIngredient(potionMap, ingredient.getRegistryName().toString(), effects);
    }

    private static void addPotionIngredient(List<String> potionMap, String itemRegistryName, String ... effects) {
        StringJoiner effectsString = new StringJoiner(";");
        Arrays.stream(effects).forEach(effectsString::add);
        potionMap.add(String.format("%s=%s", itemRegistryName, effectsString));
    }
}

